/* ============ */
/* calcmnsd.c	*/
/* ============ */
#include <stdio.h>
#include <miscdefs.h>
#include <math.h>

/* ------------------- */
/* FUNCTION PROTOTYPES */
/* ------------------- */
# undef F
# if defined(__STDC__) || defined(__PROTO__)
#	define  F( P )  P
# else
#	define  F( P )  ()
# endif

/* INDENT OFF */
extern	double	CalcHarm F((int, UINT));

# undef F
/* INDENT ON */

#
/* ==================================================================== */
/* CalcMeanStdDev - Calculates Coupon-Width Mean & Standard Deviation	*/
/* ==================================================================== */
void
CalcMeanStdDev(UINT Width, double *Mean, double *StdDev)
{
    /* --------------------------------------------------------- */
    /* Width is maximum number of unique integers in a data set. */
    /* These equations were taken from D. E. Knuth, "The Art of  */
    /* Computer Programming," Volume 2, Seminumerical Algorithms */
    /* (1981), page 536 (top).					 */
    /* --------------------------------------------------------- */
    *Mean   = Width * (CalcHarm(1, Width) - 1);
    *StdDev = sqrt(SQR((double)Width)*(CalcHarm(2, Width) - 1)
		- *Mean);
}
# if defined(TEST_MNSD)
#include "calcharm.c"
void
main()
{
    while (main)
    {
	UINT	NumSegs, Unique;
	double	Mean, StdDev;

	AbortGracefully();

	GetUint("Enter Number of Unique Integers in Data Set: ",
		&Unique);
	GetUint("Enter Number of Segments to be Counted: ", &NumSegs);

	CalcMeanStdDev(Unique, &Mean, &StdDev);
	printf("%15u  Unique Integers\n%15u  Segments\n",
		Unique, NumSegs);
	printf("%15.f  Mean Number of Variates Required\n",
		ceil(Mean * NumSegs));
	printf("%15.f  Standard Deviation\n", ceil(StdDev * sqrt(NumSegs)));
    }
}
# endif
